/**
 * 
 */
package com.ejie.ab18a.ws.model;

import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

/**
 * @author XXXX
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
public class DatosBoletin {
	@XmlElement(name = "idPeticionTicket")
	private Integer idPeticionTicket;
	@XmlElement(name = "codEstado")
	private String codEstado;
	@XmlElement(name = "descEstado")
	private String descEstado;
	@XmlElement(name = "codError")
	private String codError;
	@XmlElement(name = "descError")
	private String descError;
	@XmlElement(name = "fechaRecepcion")
	private Date fechaRecepcion;
	@XmlElement(name = "xmlEnvioPasarela")
	private String xmlEnvioPasarela;
	@XmlElement(name = "xmlEnvioBoletin")
	private String xmlEnvioBoletin;
	@XmlElement(name = "idPoder")
	private String idPoder;
	@XmlElement(name = "idEntidadImp")
	private String idEntidadImp;
	@XmlElement(name = "idOrgano")
	private String idOrgano;
	@XmlElement(name = "idEntidadTram")
	private String idEntidadTram;
	@XmlElement(name = "idMesa")
	private String idMesa;
	@XmlElement(name = "idEstadoTram")
	private Integer idEstadoTram;
	@XmlElement(name = "codExpediente")
	private String codExpediente;
	@XmlElementWrapper(name = "errores")
	@XmlElement(name = "error", type = ErrorWS.class)
	private List<ErrorWS> errores;
	@XmlElement(name = "datRespuestaBol")
	private Ab18aDatosRespuestaEsentool datRespuestaBol;
	@XmlElementWrapper(name = "erroresValidacion")
	@XmlElement(name = "error", type = ErrorWS.class)
	private List<ErrorWS> erroresValidacion;

	@XmlTransient()
	private String resultValidLogica;
	@XmlTransient()
	private Long idOrigen;
	@XmlTransient()
	private Integer idOrigenAplicacion;

	/**
	 * @param idPeticionTicket
	 *            Integer
	 * @param codEstado
	 *            String
	 * @param descEstado
	 *            String
	 * @param fechaRecepcion
	 *            Date
	 * @param fechaEnvioBoletin
	 *            Date
	 * @param fechaActualizacion
	 *            Date
	 * @param fechaPublicacion
	 *            Date
	 * @param listaErroresBoletin
	 *            List<Ab18aValidacionBoletin>
	 * @param xmlEnvioPasarela
	 *            String
	 * @param xmlEnvioBoletin
	 *            String
	 * @param idPoder
	 *            Integer
	 * @param idEntidadImp
	 *            Integer
	 * @param idOrgano
	 *            Integer
	 * @param idEntidadTram
	 *            Integer
	 * @param idMesa
	 *            Integer
	 * @param idEstadoTram
	 *            Integer
	 * @param codExpediente
	 *            String
	 * @param errores
	 *            List<ErrorWS>
	 * @param idOrigen
	 *            Long
	 * @param idOrigenAplicacion
	 *            Integer
	 * @param resultValidLogica
	 *            String
	 */
	public DatosBoletin(Integer idPeticionTicket, String codEstado, String descEstado, Date fechaRecepcion, Date fechaEnvioBoletin,
			Date fechaActualizacion, Date fechaPublicacion, List<Ab18aValidacionBoletin> listaErroresBoletin, String xmlEnvioPasarela,
			String xmlEnvioBoletin, String idPoder, String idEntidadImp, String idOrgano, String idEntidadTram, String idMesa, Integer idEstadoTram,
			String codExpediente, List<ErrorWS> errores, Long idOrigen, Integer idOrigenAplicacion, String resultValidLogica, String codError,
			String descError) {
		this.idPeticionTicket = idPeticionTicket;
		this.codEstado = codEstado;
		this.descEstado = descEstado;
		this.fechaRecepcion = fechaRecepcion;
		this.xmlEnvioPasarela = xmlEnvioPasarela;
		this.xmlEnvioBoletin = xmlEnvioBoletin;
		this.idPoder = idPoder;
		this.idEntidadImp = idEntidadImp;
		this.idOrgano = idOrgano;
		this.idEntidadTram = idEntidadTram;
		this.idMesa = idMesa;
		this.idEstadoTram = idEstadoTram;
		this.codExpediente = codExpediente;
		this.errores = errores;
		this.idOrigen = idOrigen;
		this.idOrigenAplicacion = idOrigenAplicacion;
		this.resultValidLogica = resultValidLogica;
		this.codError = codError;
		this.descError = descError;
	}

	/**
	 * @return the idPeticionTicket
	 */
	public Integer getIdPeticionTicket() {
		return this.idPeticionTicket;
	}

	/**
	 * @return the codEstado
	 */
	public String getCodEstado() {
		return this.codEstado;
	}

	/**
	 * @return the descEstado
	 */
	public String getDescEstado() {
		return this.descEstado;
	}

	/**
	 * @return the fechaRecepcion
	 */
	public Date getFechaRecepcion() {
		return this.fechaRecepcion;
	}

	/**
	 * @return the xmlEnvioPasarela
	 */
	public String getXmlEnvioPasarela() {
		return this.xmlEnvioPasarela;
	}

	/**
	 * @return the xmlEnvioBoletin
	 */
	public String getXmlEnvioBoletin() {
		return this.xmlEnvioBoletin;
	}

	/**
	 * @return the idPoder
	 */
	public String getIdPoder() {
		return this.idPoder;
	}

	/**
	 * @return the idEntidadImp
	 */
	public String getIdEntidadImp() {
		return this.idEntidadImp;
	}

	/**
	 * @return the idOrgano
	 */
	public String getIdOrgano() {
		return this.idOrgano;
	}

	/**
	 * @return the idEntidadTram
	 */
	public String getIdEntidadTram() {
		return this.idEntidadTram;
	}

	/**
	 * @return the idMesa
	 */
	public String getIdMesa() {
		return this.idMesa;
	}

	/**
	 * @return the idEstadoTram
	 */
	public Integer getIdEstadoTram() {
		return this.idEstadoTram;
	}

	/**
	 * @return the codExpediente
	 */
	public String getCodExpediente() {
		return this.codExpediente;
	}

	/**
	 * @return the errores
	 */
	public List<ErrorWS> getErrores() {
		return this.errores;
	}

	/**
	 * @param idPeticionTicket
	 *            the idPeticionTicket to set
	 */
	public void setIdPeticionTicket(Integer idPeticionTicket) {
		this.idPeticionTicket = idPeticionTicket;
	}

	/**
	 * @param codEstado
	 *            the codEstado to set
	 */
	public void setCodEstado(String codEstado) {
		this.codEstado = codEstado;
	}

	/**
	 * @param descEstado
	 *            the descEstado to set
	 */
	public void setDescEstado(String descEstado) {
		this.descEstado = descEstado;
	}

	/**
	 * @param fechaRecepcion
	 *            the fechaRecepcion to set
	 */
	public void setFechaRecepcion(Date fechaRecepcion) {
		this.fechaRecepcion = fechaRecepcion;
	}

	/**
	 * @param xmlEnvioPasarela
	 *            the xmlEnvioPasarela to set
	 */
	public void setXmlEnvioPasarela(String xmlEnvioPasarela) {
		this.xmlEnvioPasarela = xmlEnvioPasarela;
	}

	/**
	 * @param xmlEnvioBoletin
	 *            the xmlEnvioBoletin to set
	 */
	public void setXmlEnvioBoletin(String xmlEnvioBoletin) {
		this.xmlEnvioBoletin = xmlEnvioBoletin;
	}

	/**
	 * @param idPoder
	 *            the idPoder to set
	 */
	public void setIdPoder(String idPoder) {
		this.idPoder = idPoder;
	}

	/**
	 * @param idEntidadImp
	 *            the idEntidadImp to set
	 */
	public void setIdEntidadImp(String idEntidadImp) {
		this.idEntidadImp = idEntidadImp;
	}

	/**
	 * @param idOrgano
	 *            the idOrgano to set
	 */
	public void setIdOrgano(String idOrgano) {
		this.idOrgano = idOrgano;
	}

	/**
	 * @param idEntidadTram
	 *            the idEntidadTram to set
	 */
	public void setIdEntidadTram(String idEntidadTram) {
		this.idEntidadTram = idEntidadTram;
	}

	/**
	 * @param idMesa
	 *            the idMesa to set
	 */
	public void setIdMesa(String idMesa) {
		this.idMesa = idMesa;
	}

	/**
	 * @param idEstadoTram
	 *            the idEstadoTram to set
	 */
	public void setIdEstadoTram(Integer idEstadoTram) {
		this.idEstadoTram = idEstadoTram;
	}

	/**
	 * @param codExpediente
	 *            the codExpediente to set
	 */
	public void setCodExpediente(String codExpediente) {
		this.codExpediente = codExpediente;
	}

	/**
	 * @param errores
	 *            the errores to set
	 */
	public void setErrores(List<ErrorWS> errores) {
		this.errores = errores;
	}

	/**
	 * Constructor
	 */
	public DatosBoletin() {
	}

	/**
	 * @return the datRespuestaBol
	 */
	public Ab18aDatosRespuestaEsentool getDatRespuestaBol() {
		return this.datRespuestaBol;
	}

	/**
	 * @param datRespuestaBol
	 *            the datRespuestaBol to set
	 */
	public void setDatRespuestaBol(Ab18aDatosRespuestaEsentool datRespuestaBol) {
		this.datRespuestaBol = datRespuestaBol;
	}

	/**
	 * @return the idOrigen
	 */
	public Long getIdOrigen() {
		return this.idOrigen;
	}

	/**
	 * @return the idOrigenAplicacion
	 */
	public Integer getIdOrigenAplicacion() {
		return this.idOrigenAplicacion;
	}

	/**
	 * @param idOrigen
	 *            the idOrigen to set
	 */
	public void setIdOrigen(Long idOrigen) {
		this.idOrigen = idOrigen;
	}

	/**
	 * @param idOrigenAplicacion
	 *            the idOrigenAplicacion to set
	 */
	public void setIdOrigenAplicacion(Integer idOrigenAplicacion) {
		this.idOrigenAplicacion = idOrigenAplicacion;
	}

	/**
	 * @return the resultValidLogica
	 */
	public String getResultValidLogica() {
		return this.resultValidLogica;
	}

	/**
	 * @param resultValidLogica
	 *            the resultValidLogica to set
	 */
	public void setResultValidLogica(String resultValidLogica) {
		this.resultValidLogica = resultValidLogica;
	}

	/**
	 * @return the erroresValidacion
	 */
	public List<ErrorWS> getErroresValidacion() {
		return this.erroresValidacion;
	}

	/**
	 * @param erroresValidacion
	 *            the erroresValidacion to set
	 */
	public void setErroresValidacion(List<ErrorWS> erroresValidacion) {
		this.erroresValidacion = erroresValidacion;
	}

	/**
	 * @return the codError
	 */
	public String getCodError() {
		return codError;
	}

	/**
	 * @return the descError
	 */
	public String getDescError() {
		return descError;
	}

	/**
	 * @param codError
	 *            the codError to set
	 */
	public void setCodError(String codError) {
		this.codError = codError;
	}

	/**
	 * @param descError
	 *            the descError to set
	 */
	public void setDescError(String descError) {
		this.descError = descError;
	}
}
